/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightParticleTypes;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class ShockWaveParticleOption
implements ParticleOptions {
    public static final Codec<ShockWaveParticleOption> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("extra_size").forGetter(ShockWaveParticleOption::getCountdown)).apply((Applicative)instance, ShockWaveParticleOption::new));
    public static final ParticleOptions.Deserializer<ShockWaveParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<ShockWaveParticleOption>(){

        public ShockWaveParticleOption fromCommand(ParticleType<ShockWaveParticleOption> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int extra_size = reader.readInt();
            return new ShockWaveParticleOption(extra_size);
        }

        public ShockWaveParticleOption fromNetwork(ParticleType<ShockWaveParticleOption> type, FriendlyByteBuf buffer) {
            return new ShockWaveParticleOption(buffer.m_130242_());
        }
    };
    private final int extra_size;

    public ShockWaveParticleOption(int extra_size) {
        this.extra_size = extra_size;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.extra_size);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.extra_size);
    }

    @NotNull
    public ParticleType<ShockWaveParticleOption> m_6012_() {
        return (ParticleType)ImmortalersDelightParticleTypes.SHOCK_WAVE.get();
    }

    public int getCountdown() {
        return this.extra_size;
    }
}

